// priority: 100
onEvent('recipes', (event) => {
    //Define some soils
    var soils = {
        normal: [
            {
                tag: 'minecraft:dirt'
            },
            {
                tag: 'forge:gravel'
            },
            {
                tag: 'minecraft:sand'
            }
        ],
        stone: [
            {
                tag: 'forge:stone'
            }
        ],
        sand: [
            {
                tag: 'minecraft:sand'
            }
        ],
        alien: [
            {
                tag: 'forge:end_stones'
            }
        ],
        underworld: [
            {
                tag: 'forge:netherrack'
            }
        ],
        otherworld: [
            {
                item: 'occultism:otherstone'
            }
        ]
    }

    //Method to add a mob spawn to the RFTools Spawner
    //Don't need to add vanilla mobs, they are already all added by default.
    //Format for tag as ingredient: addSpawn('minecraft:bat', '#forge:feathers', 0.2, soils.dirt, 10, 100)
    //Format for item as ingredient: addSpawn('minecraft:bat', 'minecraft:feather', 0.2, soils.dirt, 10, 100)
    const addSpawn = (mob, key, soilsAmount, soils, livingMatterAmount, powerRequired) => {
        //The ingredient, parsed as tag or item using a # prefix for tag (no prefix for item)
        var ing;
        if(key[0] == "#") {
            ing = {
                tag: key.substring(1)
            }
        } else {
            ing = {
                item: key
            }
        }
        //The identifier which is apparently required internally
        //e.g.: 'minecraft:bat' becomes 'minecraft_bat'
        var identifier = mob.replace(":", "_")
        
        //Add the recipe
        event.custom({
            type: 'rftoolsutility:spawner',
            id: identifier,
            power: powerRequired,
            entity: mob,
            item1: {
                amount: 0.1,
                ingredient: ing
            },
            item2: {
                amount: soilsAmount,
                ingredient: soils
            },
            item3: {
                amount: livingMatterAmount,
                living: true
            }
        });
    }


    //Soils: normal, stone, sand, alien, underworld, arcane
    //addSpawn = (mob, key, soilsAmount, soils, livingMatterAmount, powerRequired)
    //Amount of the 'key' required is always 0.1 (10 spawns per item)

    //Ars Nouveau (could not add Wilden Boss, it makes the script go boom)
    addSpawn('ars_nouveau:amethyst_golem', '#forge:gems/amethyst', 0.2, soils.stone, 15, 500)
    addSpawn('ars_nouveau:drygmy', 'ars_nouveau:wilden_horn', 0.2, soils.normal, 15, 500)
    addSpawn('ars_nouveau:starbuncle', '#forge:nuggets/gold', 0.2, soils.normal, 15, 500)
    addSpawn('ars_nouveau:whirlisprig', '#minecraft:saplings', 0.2, soils.normal, 15, 500)
    addSpawn('ars_nouveau:wilden_guardian', 'ars_nouveau:wilden_spike', 0.2, soils.normal, 20, 800)
    addSpawn('ars_nouveau:wilden_hunter', 'ars_nouveau:wilden_horn', 0.2, soils.normal, 20, 800)
    addSpawn('ars_nouveau:wilden_stalker', 'ars_nouveau:wilden_wing', 0.2, soils.normal, 20, 800)

    //Nasty Skeletons
    addSpawn('nasty:skeleton', '#forge:bones', 0.5, soils.normal, 25, 1200)

    //Quark
    addSpawn('quark:crab', 'quark:crab_leg', 0.2, soils.sand, 10, 500)
    addSpawn('quark:forgotten', '#forge:bones', 0.5, soils.normal, 20, 800)
    addSpawn('quark:foxhound', 'minecraft:coal', 0.5, soils.underworld, 20, 800)
    addSpawn('quark:frog', 'quark:frog_leg', 0.2, soils.normal, 10, 500)
    addSpawn('quark:shiba', 'minecraft:bone', 0.2, soils.normal, 20, 800)
    addSpawn('quark:stoneling', 'quark:diamond_heart', 0.5, soils.stone, 20, 1500)
    addSpawn('quark:toretoise', '#forge:raw_materials', 0.5, soils.stone, 20, 1000)
    addSpawn('quark:wraith', 'quark:soul_bead', 0.2, soils.underworld, 20, 800)

    //Resourceful Creepers
    addSpawn('resourcefulcreepers:aluminum_ore', '#forge:raw_materials/aluminum', 2.0, soils.stone, 20, 2000)
    addSpawn('resourcefulcreepers:ancient_debris', '#forge:ores/netherite_scrap', 2.0, soils.underworld, 20, 15000)
    addSpawn('resourcefulcreepers:blazing_quartz_ore', 'malum:blazing_quartz', 2.0, soils.underworld, 20, 800)
    addSpawn('resourcefulcreepers:certus_quartz_ore', '#forge:gems/certus_quartz', 2.0, soils.stone, 20, 1400)
    addSpawn('resourcefulcreepers:coal_ore', 'minecraft:coal', 2.0, soils.stone, 20, 2000)
    addSpawn('resourcefulcreepers:cobalt_ore', '#forge:raw_materials/cobalt', 2.0, soils.underworld, 20, 3000)
    addSpawn('resourcefulcreepers:copper_ore', '#forge:raw_materials/copper', 2.0, soils.stone, 20, 1500)
    addSpawn('resourcefulcreepers:diamond_ore', '#forge:gems/diamond', 2.0, soils.stone, 20, 8000)
    addSpawn('resourcefulcreepers:dimensionalshard_end', 'rftoolsbase:dimensionalshard', 2.0, soils.alien, 20, 2000)
    addSpawn('resourcefulcreepers:dimensionalshard_overworld', 'rftoolsbase:dimensionalshard', 2.0, soils.stone, 20, 2000)
    addSpawn('resourcefulcreepers:emerald_ore', '#forge:gems/emerald', 2.0, soils.stone, 20, 8000)
    addSpawn('resourcefulcreepers:end_quartz_ore', '#forge:gems/quartz', 2.0, soils.alien, 20, 3000)
    addSpawn('resourcefulcreepers:gold_ore', '#forge:raw_materials/gold', 2.0, soils.stone, 20, 4000)
    addSpawn('resourcefulcreepers:iron_ore', '#forge:raw_materials/iron', 2.0, soils.stone, 20, 3000)
    addSpawn('resourcefulcreepers:lapis_ore', '#forge:gems/lapis', 2.0, soils.stone, 20, 2500)
    addSpawn('resourcefulcreepers:lead_ore', '#forge:raw_materials/lead', 2.0, soils.stone, 20, 3000)
    addSpawn('resourcefulcreepers:nether_gold_ore', '#forge:nuggets/gold', 2.0, soils.underworld, 20, 3000)
    addSpawn('resourcefulcreepers:nether_quartz_ore', '#forge:gems/quartz', 2.0, soils.underworld, 20, 3000)
    addSpawn('resourcefulcreepers:nickel_ore', '#forge:raw_materials/nickel', 2.0, soils.stone, 20, 2000)
    addSpawn('resourcefulcreepers:prosperity_ore', 'mysticalagriculture:prosperity_shard', 2.0, soils.stone, 20, 4000)
    addSpawn('resourcefulcreepers:redstone_ore', '#forge:dusts/redstone', 2.0, soils.stone, 20, 5000)
    addSpawn('resourcefulcreepers:silver_ore', '#forge:raw_materials/silver', 2.0, soils.stone, 20, 2000)
    addSpawn('resourcefulcreepers:soulium_ore', 'mysticalagriculture:soulium_dust', 2.0, soils.underworld, 20, 2000)
    addSpawn('resourcefulcreepers:soulstone_ore', 'malum:raw_soulstone', 2.0, soils.stone, 20, 2000)
    addSpawn('resourcefulcreepers:uranium_ore', '#forge:raw_materials/uranium', 2.0, soils.stone, 20, 4000)
    addSpawn('resourcefulcreepers:zinc_ore', '#forge:raw_materials/zinc', 2.0, soils.stone, 20, 3000)
    
    addSpawn('resourcefulcreepers:apatite_ore', '#forge:gems/apatite', 2.0, soils.stone, 20, 2000)
    addSpawn('resourcefulcreepers:aquamarine_ore', '#forge:gems/aquamarine', 2.0, soils.stone, 20, 1000)
    addSpawn('resourcefulcreepers:cinnabar_ore', '#forge:gems/cinnabar', 2.0, soils.stone, 20, 6000)
    addSpawn('resourcefulcreepers:end_diamond_ore', '#forge:gems/diamond', 2.0, soils.alien, 20, 16000)
    addSpawn('resourcefulcreepers:end_redstone_ore', '#forge:dusts/redstone', 2.0, soils.alien, 20, 10000)
    addSpawn('resourcefulcreepers:ender_ore', '#forge:ender_pearls', 2.0, soils.alien, 20, 10000)
    addSpawn('resourcefulcreepers:fluorite_ore', '#forge:gems/fluorite', 2.0, soils.stone, 20, 3000)
    addSpawn('resourcefulcreepers:ghast_ore', 'minecraft:ghast_tear', 2.0, soils.underworld, 20, 9000)
    addSpawn('resourcefulcreepers:nether_iron_ore', '#forge:raw_materials/iron', 2.0, soils.underworld, 20, 6000)
    addSpawn('resourcefulcreepers:nether_lapis_ore', '#forge:gems/lapis', 2.0, soils.underworld, 20, 5000)
    addSpawn('resourcefulcreepers:niter_ore', '#forge:gems/niter', 2.0, soils.stone, 20, 4000)
    addSpawn('resourcefulcreepers:osmium_ore', '#forge:raw_materials/osmium', 2.0, soils.stone, 20, 3000)
    addSpawn('resourcefulcreepers:ruby_ore', '#forge:gems/ruby', 2.0, soils.stone, 20, 2000)
    addSpawn('resourcefulcreepers:sapphire_ore', '#forge:gems/sapphire', 2.0, soils.stone, 20, 2000)
    addSpawn('resourcefulcreepers:sulfur_ore', '#forge:gems/sulfur', 2.0, soils.stone, 20, 4000)
    addSpawn('resourcefulcreepers:brilliant_stone', 'malum:cluster_of_brilliance', 2.0, soils.stone, 20, 6000)
    addSpawn('resourcefulcreepers:tin_ore', '#forge:raw_materials/tin', 2.0, soils.stone, 20, 3000)
    addSpawn('resourcefulcreepers:iesnium_ore', '#forge:raw_materials/iesnium', 2.0, soils.otherworld, 20, 4000)

    //TConstruct slimes
    addSpawn('tconstruct:earth_slime', '#forge:slimeball/earth', 0.2, soils.normal, 15, 800)
    addSpawn('tconstruct:ender_slime', '#forge:slimeball/ender', 0.2, soils.alien, 15, 800)
    addSpawn('tconstruct:sky_slime', '#forge:slimeball/sky', 0.2, soils.normal, 15, 800)
    addSpawn('tconstruct:terracube', '#forge:clay', 0.2, soils.normal, 15, 800)

    //Duckies
    addSpawn('duckies:duck', '#forge:feathers', 0.1, soils.normal, 15, 500)

    //Thermal
    addSpawn('thermal:basalz', '#forge:slag', 0.5, soils.normal, 20, 1000)
    addSpawn('thermal:blitz', '#forge:gems/niter', 0.5, soils.normal, 20, 1000)
    addSpawn('thermal:blizz', 'minecraft:snowball', 0.5, soils.normal, 20, 1000)
});

